/*
 * Decompiled with CFR 0.152.
 */
package composants;

import base.Actualisable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import ressources.Images;

public class PanelImage
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Rectangle bounds;
    private BufferedImage image;
    private boolean max;

    public PanelImage() {
        this.setOpaque(false);
        this.bounds = new Rectangle();
    }

    public PanelImage(BufferedImage image) {
        this();
        this.setImage(image);
    }

    public PanelImage(BufferedImage image, boolean max) {
        this(image);
        this.setMax(max);
    }

    public PanelImage(String nom) {
        this(nom, true);
    }

    public PanelImage(String nom, boolean max) {
        this(nom == null ? null : Images.get(nom), max);
    }

    public Rectangle getZone() {
        return this.bounds;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.image != null) {
            this.setZone(this.image);
            g.drawImage(this.image, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, null);
        }
        super.paintComponent(g);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.repaint();
    }

    public void setImage(String image) {
        this.setImage(Images.get(image));
    }

    public PanelImage tailleImage() {
        if (this.image != null) {
            this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        }
        return this;
    }

    public void setMax(boolean max) {
        this.max = max;
    }

    public void setZone(BufferedImage image) {
        this.bounds.x = 0;
        this.bounds.y = 0;
        this.bounds.width = this.getWidth();
        this.bounds.height = this.getHeight();
        if (!this.max) {
            if (this.getHeight() - image.getHeight() > this.getWidth() - image.getWidth()) {
                this.bounds.height = image.getHeight() * this.bounds.width / image.getWidth();
                this.bounds.y = (this.getHeight() - this.bounds.height) / 2;
            } else {
                this.bounds.width = image.getWidth() * this.bounds.height / image.getHeight();
                this.bounds.x = (this.getWidth() - this.bounds.width) / 2;
            }
        }
    }

    public void addActualisable(Actualisable l) {
        this.listenerList.add(Actualisable.class, l);
    }

    public void removeActualisable(Actualisable l) {
        this.listenerList.remove(Actualisable.class, l);
    }

    protected void notifyActualisables() {
        Actualisable[] actualisableArray = (Actualisable[])this.listenerList.getListeners(Actualisable.class);
        int n = actualisableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Actualisable l = actualisableArray[n2];
            l.actualise();
            ++n2;
        }
    }
}

